'use strict'

entityRegistry['module']['floorField'] = {
    extendedInfo: {
        displayName: 'Floor Field',
        displayGroup: '3D Effects',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'minX', displayName: 'Min X', type: 'int', defaultValue: -2},
        { paramName: 'maxX', displayName: 'Max X', type: 'int', defaultValue: +2},
        { paramName: 'minZ', displayName: 'Min Z', type: 'int', defaultValue: -2},
        { paramName: 'maxZ', displayName: 'Max Z', type: 'int', defaultValue: +2},
        { paramName: 'worldScale', displayName: 'Scale', type: 'float', defaultValue: 1},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                minX,
                maxX,
                minZ,
                maxZ,
                worldScale
            } = { ...config }


            // const model = getModel('default')
            const model = {
                verts: [
                    [0,-1,1],[.866025,-1,.5],[.866025,-1,-.5],[0,-1,-1],[-.866025,-1,-0.5],[-.866025,-1,0.5],
                    [0,0,1],[.866025,0,.5],[.866025,0,-.5],[0,0,-1],[-.866025,0,-0.5],[-.866025,0,0.5],
                ],
                objects: [
                    {
                        name: 'bob',
                        subObjects: [
                            {
                                diffuse: [97/255, .53/255, 92/255],
                                ambient: [0, 0, 0],
                                emissive: [0, 0, 0],
                                lines: [],
                                tris: [],
                                quads: [
                                    [1, 0, 3, 2], [0, 5, 4, 3],
                                ],
                            },
                            {
                                diffuse: [106/255, 66/255, 60/255],
                                ambient: [0, 0, 0],
                                emissive: [0, 0, 0],
                                lines: [],
                                tris: [],
                                quads: [
                                    [0, 1, 7, 6],
                                    [1, 2, 8, 7],
                                    [2, 3, 9, 8],
                                    [3, 4, 10, 9],
                                    [4, 5, 11, 10],
                                    [5, 0, 6, 11],
                                ],
                            },
                        ]
                    }
                ]
            }
            renderer.decorateModel(model)
        

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const ft = frameTime * 1

            const wScale = m4.scaling(worldScale, worldScale, worldScale)
            for (let zz = minX; zz <= maxX; ++zz) {
                const z = zz*0.95
                for (let xx = minZ; xx <= maxZ; ++xx) {
                    const x = (xx + ((zz&1) ? 0 : 0.5)) * 1.1
                    const scale = Math.abs(noise.simplex3(x*.12, z*.12, frameTime*.1)) * 2
                    const transMat = m4.translation(x, 0, z)
                    const scaleMat = m4.scaling(0.65, scale, 0.65)

                    const worldMat = m4.multiply(wScale, m4.multiply(transMat, scaleMat))
                    renderer.drawModel(model, worldMat, colorBuffer, depthBuffer, brightnessBuffer, undefined)
                }
            }
        }
    }
}
